/*
 * Created by SharpDevelop.
 * User: Tom Theisen
 * Date: 12/10/2008
 * Time: 2:40 AM
 */
using System;
using System.Drawing;

namespace TriFit {
	/// <summary>
	/// Represents a translucent triangle
	/// </summary>

	public class Triangle {
		static Random rng = new Random();
		
		Color color;
		PointF[] points;
	   
		private PointF RandomPointF(int width, int height) {
	        return new PointF(
	            Convert.ToSingle(Triangle.rng.NextDouble()) * width,
	            Convert.ToSingle(Triangle.rng.NextDouble()) * height);
	    }
		
		public Triangle(Triangle triangle) {
			this.color = triangle.color;
			this.points = triangle.points;
		}
		
		public Triangle(int width, int height) {
			this.color = Color.FromArgb(
				rng.Next(0, 255), rng.Next(0, 255), rng.Next(0, 255), rng.Next(0, 255));

			this.points = new PointF[] {
	            this.RandomPointF(width, height), 
	            this.RandomPointF(width, height), 
	            this.RandomPointF(width, height)
	        };
		}
		
		public void Draw(Graphics gfx) {
			gfx.FillPolygon(new SolidBrush(this.color), this.points);
		}
	}
}
