/*
 * Created by SharpDevelop.
 * User: Tom Theisen
 * Date: 12/10/2008
 * Time: 2:39 AM
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Drawing;

namespace TriFit
{
	/// <summary>
	/// Represents an image made from tranlucent triangles
	/// </summary>
	public class TriImage {
		private static Random rng = new Random();
		Triangle[] tris;
		int width;
		int height;
		
		public TriImage(int triangles, int width, int height) {
			this.width = width;
			this.height = height;
			
			tris = new Triangle[triangles];
			
			for (int i = 0; i < triangles; i++) {
				tris[i] = new Triangle(width, height);
			}
		}
		
		public TriImage(TriImage img1, TriImage img2) {
			this.width = img1.width;
			this.height = img1.height;
			
			tris = new Triangle[img1.tris.Length];
			
			for (int i = 0; i < this.tris.Length; i++) {
				if (rng.NextDouble() < 0.01) {
					tris[i] = new Triangle(this.width, this.height);
				} else {
					tris[i] = (rng.Next(2) > 0 ? img1 : img2).tris[i];
				}
			}
		}
		
		public void Draw(Graphics gfx) {
			gfx.FillRectangle(Brushes.White, 0, 0, width, height);
			foreach (Triangle tri in tris) {
				tri.Draw(gfx);
			}
		}

		public Bitmap GetBitmap() {
			Bitmap bmp = new Bitmap(this.width, this.height);
			this.Draw(Graphics.FromImage(bmp));
			return bmp;
		}

	}
}
