﻿/*
 * Created by SharpDevelop.
 * User: Tom Theisen
 * Date: 12/9/2008
 * Time: 11:23 PM
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;

namespace TriFit {
	/// <summary>
	/// Description of MainForm.
	/// </summary>
	public partial class MainForm : Form {
	    const int WIDTH = 200;
	    const int HEIGHT = 200;
	    const int TRIANGLES = 20;
	    const int POPULATION = 100;
	    const int SURVIVORS = 20;
	    
	    static Random rng = new Random();
	    
	    Bitmap currentImage = null;
		Bitmap CurrentImage {
			get { return currentImage; }
			set { 
				currentImage = value;
		    	double diff = BitmapDifference(value, this.targetImage);
		    	this.DiffLabel.Text = string.Format("Difference: {0}", diff);
			}
		}

	    Bitmap targetImage = null;
	    
	    TriImage[] pool;
	    
		public MainForm() {
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
		}
		
	    private double BitmapDifference(Bitmap img1, Bitmap img2) {
	        double ErrSquared = 0;
	        for (int x = 0; x < img1.Width; x++) {
	            for (int y = 0; y < img1.Height; y++) {
	                Color c1 = img1.GetPixel(x, y);
	                Color c2 = img2.GetPixel(x, y);
	                double diff = (
	                    Math.Abs(c1.R - c2.R) +
	                    Math.Abs(c1.G - c2.G) +
	                    Math.Abs(c1.B - c2.B)
	                   ) / 256.0;
	                ErrSquared += diff * diff;
	            }
	        }
	        return ErrSquared;
	    }
	    
	    private void Generation() {
	    	TriImage[] next = new TriImage[POPULATION];
	    	for (int i = 0; i < POPULATION; i++) {
	    		int parent1 = rng.Next(SURVIVORS);
	    		int parent2 = rng.Next(SURVIVORS);
	    		next[i] = new TriImage(this.pool[parent1], this.pool[parent2]);
	    	}
	    	
	    	this.pool = next;
	    	
	    	double[] diffs = new double[POPULATION];
	    	for (int i = 0; i < POPULATION; i++) {
	    		this.GenerationProgressBar.Value = 100 * i / POPULATION;
	    		diffs[i] = BitmapDifference(this.targetImage, this.pool[i].GetBitmap());
	    	}
	    	
	    	Array.Sort(diffs, this.pool);
	    	
	    	this.CurrentImage = this.pool[0].GetBitmap();
	    	this.ImagePanel.Refresh();
	    }
	    
	    private void SeedPopulation() {
	    	this.pool = new TriImage[POPULATION];
	    	for (int i = 0; i < POPULATION; i++) {
	    		this.pool[i] = new TriImage(TRIANGLES, WIDTH, HEIGHT);
	    	}
	    }
		
		void DrawButtonClick(object sender, EventArgs e) {
	        Bitmap bmp = new Bitmap(WIDTH, HEIGHT); 

            Graphics bmpGraphics = Graphics.FromImage(bmp);

            TriImage cand = new TriImage(TRIANGLES, WIDTH, HEIGHT);
	        cand.Draw(bmpGraphics);

	        this.CurrentImage = bmp;
	        
            this.ImagePanel.Refresh();
   		}
		
		void LoadButtonClick(object sender, EventArgs e) {
	        if (this.OpenFileDialog.ShowDialog() == DialogResult.OK) {
	            Image img = Image.FromFile(this.OpenFileDialog.FileName);

	            Bitmap scaled = new Bitmap(WIDTH, HEIGHT);
	            Graphics gfx = Graphics.FromImage(scaled);
	            gfx.InterpolationMode = InterpolationMode.HighQualityBicubic;
	            
	            gfx.DrawImage(img, 0, 0, WIDTH, HEIGHT);
	            
	            this.targetImage = scaled;
			    this.TargetPictureBox.Image = scaled;
	        }
		}
		
		void ImagePanelPaint(object sender, PaintEventArgs e) {
	    	if (this.currentImage != null) {
		        e.Graphics.DrawImage(this.currentImage, 0, 0);
	    	}
		}
	    
		void MainFormLoad(object sender, EventArgs e) {
			this.ImagePanel.Width = WIDTH;
			this.ImagePanel.Height = HEIGHT;
			
			this.TargetPictureBox.Width = WIDTH;
			this.TargetPictureBox.Height = HEIGHT;
		}
		
		void GenerationButtonClick(object sender, EventArgs e) {
	    	if (this.pool == null) {
		    	this.SeedPopulation();
	    	}
	    	
	    	this.Generation();
		}
		
		void SeedButtonClick(object sender, EventArgs e) {
			this.SeedPopulation();
		}
		
		void LoopButtonClick(object sender, EventArgs e) {
	    	while (true) {
	    		Application.DoEvents();
	    		this.Generation();
	    		this.Refresh();
	    	}
		}
	}
}
